#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_Equipment: BaseTest 
	{
		private DataTable _dtEquipment;
		private DataTable _dtAddress;
		private DataTable _dtEquipmentMaintenance;
		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//**Address  -- we should always start with at least 1 address thanks for Facility table -- so not checking/creating new
				this._dtAddress = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 *, RowVersion as AddressRowVersion FROM Address", true);

				try
				{
					this._dtEquipment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Equipment WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}
				catch(BOL.BusinessObjectException)
				{
					this.Insert_Pass();		//Create new data with our guaranteed to pass, UnitTest
					//Grab the new data
					this._dtEquipment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Equipment WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}

				try
				{
					this._dtEquipmentMaintenance = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 EquipmentMaintenance.* FROM EquipmentMaintenance JOIN Equipment ON Equipment.EquipmentGuid = EquipmentMaintenance.EquipmentGuid WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);
				}
				catch(BOL.BusinessObjectException)
				{
					//Create a new EquipmentMaintenance record to keep tests going -- what about Address or Equipment?  Bah, who cares
					_dtEquipmentMaintenance=DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable();
					
					DataRow _drEquipmentMaintenance=this._dtEquipmentMaintenance.NewRow();
					_drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.EquipmentMaintenanceGuid]=System.Guid.NewGuid();
					_drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.EquipmentGuid]=this._dtEquipment.Rows[0][Common.VbecsTables.Equipment.EquipmentGuid];
					_drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.MaintenanceDate]=DateTime.Now.AddDays(-5);
					_drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.MaintenanceResults]="UnitTest";
					_drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.MaintenanceType]="UnitTest";
					_drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.PendingIssues]="UnitTest";
					_drEquipmentMaintenance[Common.VbecsTables.Equipment.DivisionCode]=UnitTestConfig.TestDivisionCode;
					_dtEquipmentMaintenance.Rows.Add(_drEquipmentMaintenance);

					DAL.EquipmentMaintenance.Save(this._dtEquipmentMaintenance, DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable(), Common.UpdateFunction.UnitTests);

					this._dtEquipmentMaintenance = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 EquipmentMaintenance.* FROM EquipmentMaintenance JOIN Equipment ON Equipment.EquipmentGuid = EquipmentMaintenance.EquipmentGuid WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);
				}
				this.RefreshData = false;
			}
		}

		[Test]
		public void GetEquipment_3Strings_Pass()
		{
			string equipmentType = this._dtEquipment.Rows[0][TABLES.Equipment.EquipmentType].ToString();

			DataTable dtTest = DAL.Equipment.GetEquipment(equipmentType, string.Empty, string.Empty);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(27, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentGuid), TABLES.Equipment.EquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentName), TABLES.Equipment.EquipmentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentType), TABLES.Equipment.EquipmentType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ManufacturerName), TABLES.Equipment.ManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ManufacturerPhoneNumber), TABLES.Equipment.ManufacturerPhoneNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ReceiptDate), TABLES.Equipment.ReceiptDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ReceiptTechId), TABLES.Equipment.ReceiptTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.AddressGuid), TABLES.Equipment.AddressGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.InvoiceNumber), TABLES.Equipment.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.SerialNumber), TABLES.Equipment.SerialNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.LocalIdentifier), TABLES.Equipment.LocalIdentifier);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.MaintenanceContractNumber), TABLES.Equipment.MaintenanceContractNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.MaintenanceContractDate), TABLES.Equipment.MaintenanceContractDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.InspectionIndicator), TABLES.Equipment.InspectionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.OutOfServiceIndicator), TABLES.Equipment.OutOfServiceIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.Comments), TABLES.Equipment.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.NextMaintenanceText), TABLES.Equipment.NextMaintenanceText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.DivisionCode), TABLES.Equipment.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.RowVersion), TABLES.Equipment.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressGuid), TABLES.Address.AddressGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine1), TABLES.Address.AddressLine1);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine2), TABLES.Address.AddressLine2);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine3), TABLES.Address.AddressLine3);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressCity), TABLES.Address.AddressCity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.StateCode), TABLES.Address.StateCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressZipCode), TABLES.Address.AddressZipCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.AddressRowVersion), ARTIFICIAL.AddressRowVersion);

			DataTable dtTest2 = DAL.Equipment.GetEquipment(string.Empty, string.Empty, string.Empty);
			Assert.AreEqual(true, dtTest2.Rows.Count > 0, "AllBlank-Rows.Count");
			Assert.AreEqual(dtTest.Columns.Count, dtTest2.Columns.Count, "AllBlank-Columns.Count");
		}

		[Test]
		public void GetEquipment_3Strings_Fail()
		{
			DataTable dtTest = DAL.Equipment.GetEquipment("Lohse", "Was", "Here");

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetEquipment_All_Pass()
		{
			DataTable dtTest = DAL.Equipment.GetEquipment();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(27, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentGuid), TABLES.Equipment.EquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentName), TABLES.Equipment.EquipmentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentType), TABLES.Equipment.EquipmentType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ManufacturerName), TABLES.Equipment.ManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ManufacturerPhoneNumber), TABLES.Equipment.ManufacturerPhoneNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ReceiptDate), TABLES.Equipment.ReceiptDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ReceiptTechId), TABLES.Equipment.ReceiptTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.AddressGuid), TABLES.Equipment.AddressGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.InvoiceNumber), TABLES.Equipment.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.SerialNumber), TABLES.Equipment.SerialNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.LocalIdentifier), TABLES.Equipment.LocalIdentifier);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.MaintenanceContractNumber), TABLES.Equipment.MaintenanceContractNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.MaintenanceContractDate), TABLES.Equipment.MaintenanceContractDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.InspectionIndicator), TABLES.Equipment.InspectionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.OutOfServiceIndicator), TABLES.Equipment.OutOfServiceIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.Comments), TABLES.Equipment.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.NextMaintenanceText), TABLES.Equipment.NextMaintenanceText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.DivisionCode), TABLES.Equipment.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.RowVersion), TABLES.Equipment.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressGuid), TABLES.Address.AddressGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine1), TABLES.Address.AddressLine1);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine2), TABLES.Address.AddressLine2);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine3), TABLES.Address.AddressLine3);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressCity), TABLES.Address.AddressCity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.StateCode), TABLES.Address.StateCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressZipCode), TABLES.Address.AddressZipCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.AddressRowVersion), ARTIFICIAL.AddressRowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEquipment_All_Fail()
		{
		}

		[Test]
		public void GetEquipmentDetails_Pass()
		{
			DataSet dsTest = DAL.Equipment.GetEquipmentDetails();

			Assert.AreEqual(2, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Rows.Count > 0, "[0]-Rows.Count");
			Assert.AreEqual(1, dsTest.Tables[0].Columns.Count, "[0]-Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.EquipmentType), TABLES.Equipment.EquipmentType);

			Assert.AreEqual(true, dsTest.Tables[1].Rows.Count > 0, "[1]-Rows.Count");
			Assert.AreEqual(1, dsTest.Tables[1].Columns.Count, "[1]-Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.Equipment.ManufacturerName), TABLES.Equipment.ManufacturerName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEquipmentDetails_Fail()
		{
		}

		[Test]
		public void GetEmptyEquipmentTable_Pass()
		{
			DataTable dtTest = DAL.Equipment.GetEmptyEquipmentTable();

			Assert.AreEqual(TABLES.Equipment.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(19, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.Comments), TABLES.Equipment.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.DivisionCode), TABLES.Equipment.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentGuid), TABLES.Equipment.EquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentName), TABLES.Equipment.EquipmentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.InspectionIndicator), TABLES.Equipment.InspectionIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.OutOfServiceIndicator), TABLES.Equipment.OutOfServiceIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentType), TABLES.Equipment.EquipmentType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.InvoiceNumber), TABLES.Equipment.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.LocalIdentifier), TABLES.Equipment.LocalIdentifier);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.MaintenanceContractDate), TABLES.Equipment.MaintenanceContractDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.MaintenanceContractNumber), TABLES.Equipment.MaintenanceContractNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ManufacturerName), TABLES.Equipment.ManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ManufacturerPhoneNumber), TABLES.Equipment.ManufacturerPhoneNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.NextMaintenanceText), TABLES.Equipment.NextMaintenanceText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ReceiptDate), TABLES.Equipment.ReceiptDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ReceiptTechId), TABLES.Equipment.ReceiptTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.RowVersion), TABLES.Equipment.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.SerialNumber), TABLES.Equipment.SerialNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.AddressGuid), TABLES.Equipment.AddressGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyEquipmentTable_Fail()
		{
		}

		[Test]
		public void GetEquipmentByGuid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtEquipment.Rows[0][TABLES.Equipment.EquipmentGuid];

			DataTable dtTest = DAL.Equipment.GetEquipmentByGuid(unitGuid);

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(26, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentGuid), TABLES.Equipment.EquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentName), TABLES.Equipment.EquipmentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentType), TABLES.Equipment.EquipmentType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ManufacturerName), TABLES.Equipment.ManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.AddressGuid), TABLES.Equipment.AddressGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine1), TABLES.Address.AddressLine1);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine2), TABLES.Address.AddressLine2);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine3), TABLES.Address.AddressLine3);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressCity), TABLES.Address.AddressCity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.StateCode), TABLES.Address.StateCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressZipCode), TABLES.Address.AddressZipCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.AddressRowVersion), ARTIFICIAL.AddressRowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ManufacturerPhoneNumber), TABLES.Equipment.ManufacturerPhoneNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ReceiptDate), TABLES.Equipment.ReceiptDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ReceiptTechId), TABLES.Equipment.ReceiptTechId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.InvoiceNumber), TABLES.Equipment.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.SerialNumber), TABLES.Equipment.SerialNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.LocalIdentifier), TABLES.Equipment.LocalIdentifier);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.MaintenanceContractNumber), TABLES.Equipment.MaintenanceContractNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.MaintenanceContractDate), TABLES.Equipment.MaintenanceContractDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.InspectionIndicator), TABLES.Equipment.InspectionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.OutOfServiceIndicator), TABLES.Equipment.OutOfServiceIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.Comments), TABLES.Equipment.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.NextMaintenanceText), TABLES.Equipment.NextMaintenanceText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.DivisionCode), TABLES.Equipment.DivisionCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.RowVersion), TABLES.Equipment.RowVersion);
		}

		[Test]
		public void GetEquipmentByGuid_Fail()
		{
			DataTable dtTest = DAL.Equipment.GetEquipmentByGuid(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetEquipmentBySerialNumberAndManufacturer_Pass()
		{
			string serialNumber = this._dtEquipment.Rows[0][TABLES.Equipment.SerialNumber].ToString();
			string manufacturer = this._dtEquipment.Rows[0][TABLES.Equipment.ManufacturerName].ToString();

			DataTable dtTest = DAL.Equipment.GetEquipmentBySerialNumberAndManufacturer(serialNumber, manufacturer);
	
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentGuid), TABLES.Equipment.EquipmentGuid);
		}

		[Test]
		public void GetEquipmentBySerialNumberAndManufacturer_Fail()
		{
			DataTable dtTest = DAL.Equipment.GetEquipmentBySerialNumberAndManufacturer("Froomby", "Manastone");

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void Insert_Pass()
		{
			this.RefreshData = true;

			System.Guid addressGuid = System.Guid.NewGuid();

			DataTable dtAddress = SprocHelper.GetInsertAddressSprocTable(addressGuid);
			DataTable dtEquipment = SprocHelper.GetInsertEquipmentSprocTable(System.Guid.NewGuid(), addressGuid);

			System.Guid [] equipGuids = new Guid[1];
			equipGuids[0] = System.Guid.NewGuid();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.LoginEquipment);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.LoginEquipment, equipGuids, Common.WorkloadTransactionType.Miscellanious, false);
			bool retValue = DAL.Equipment.Insert(dtEquipment, dtAddress, dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void Insert_Fail()
		{
			DataTable dtAddress = SprocHelper.GetInsertAddressSprocTable(System.Guid.NewGuid());
			DataTable dtEquipment = SprocHelper.GetInsertEquipmentSprocTable(System.Guid.NewGuid(), System.Guid.NewGuid());
			DataTable dtWorkloadEvents = null;
			System.Guid [] equipGuids = new Guid[1];
			equipGuids[0] = System.Guid.NewGuid();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.LoginEquipment);
			dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.LoginEquipment, equipGuids, Common.WorkloadTransactionType.Miscellanious, false);
			//The missing addressguid tie - will fail this
			DAL.Equipment.Insert(dtEquipment, dtAddress, dtWorkloadEvents, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void Update_Pass()
		{
			this.RefreshData = true;

			System.Guid equipGuid = (System.Guid)this._dtEquipment.Rows[0][TABLES.Equipment.EquipmentGuid];
			System.Guid addressGuid = (System.Guid)this._dtAddress.Rows[0][TABLES.Address.AddressGuid];
			System.Guid emGuid = (System.Guid)this._dtEquipmentMaintenance.Rows[0][TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid];

			byte[] addressRowVersion = (byte[])this._dtAddress.Rows[0][ARTIFICIAL.AddressRowVersion];
			byte[] equipRowVersion = (byte[])this._dtEquipment.Rows[0][TABLES.Equipment.RowVersion];
			byte[] emRowVersion = (byte[])this._dtEquipmentMaintenance.Rows[0][TABLES.EquipmentMaintenance.RowVersion];

			DataTable dtUAddress = SprocHelper.GetUpdateAddressSprocTable(addressGuid, addressRowVersion);
			DataTable dtUEquipment = SprocHelper.GetUpdateEquipmentSprocTable(equipGuid, equipRowVersion);
			DataTable dtIEquipMaintenance = SprocHelper.GetInsertEquipmentMaintenanceSprocTable(System.Guid.NewGuid(), equipGuid);
			DataTable dtUEquipMaintenance = SprocHelper.GetUpdateEquipmentMaintenanceSprocTable(emGuid, equipGuid, emRowVersion);

			dtUEquipment.Rows[0][TABLES.Equipment.AddressGuid] = addressGuid;
			System.Guid [] equipGuids = new Guid[1];
			equipGuids[0] = equipGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UpdateEquipmentRecord);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UpdateEquipmentRecord, equipGuids, Common.WorkloadTransactionType.Miscellanious, false);
			bool retValue = DAL.Equipment.Update(dtUEquipment, dtUAddress, dtIEquipMaintenance, dtUEquipMaintenance, dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void Update_Fail()
		{
			this.RefreshData = true;

			System.Guid equipGuid = (System.Guid)this._dtEquipment.Rows[0][TABLES.Equipment.EquipmentGuid];
			System.Guid addressGuid = (System.Guid)this._dtAddress.Rows[0][TABLES.Address.AddressGuid];
			System.Guid emGuid = (System.Guid)this._dtEquipmentMaintenance.Rows[0][TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid];

			byte[] addressRowVersion = new byte[8];
			byte[] equipRowVersion = new byte[8];
			byte[] emRowVersion = new byte[8];

			DataTable dtUAddress = SprocHelper.GetUpdateAddressSprocTable(addressGuid, addressRowVersion);
			DataTable dtUEquipment = SprocHelper.GetUpdateEquipmentSprocTable(equipGuid, equipRowVersion);
			DataTable dtIEquipMaintenance = SprocHelper.GetInsertEquipmentMaintenanceSprocTable(System.Guid.NewGuid(), equipGuid);
			DataTable dtUEquipMaintenance = SprocHelper.GetUpdateEquipmentMaintenanceSprocTable(emGuid, equipGuid, emRowVersion);

			dtUEquipment.Rows[0][TABLES.Equipment.AddressGuid] = addressGuid;
			
			System.Guid [] equipGuids = new Guid[1];
			equipGuids[0] = equipGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UpdateEquipmentRecord);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UpdateEquipmentRecord, equipGuids, Common.WorkloadTransactionType.Miscellanious, false);
			DAL.Equipment.Update(dtUEquipment, dtUAddress, dtIEquipMaintenance, dtUEquipMaintenance, dtWorkloadEvents, Common.UpdateFunction.UnitTests);

		}

		[Test]
		public void GetEquipmentTypes_Pass()
		{
			DataTable dtTest = DAL.Equipment.GetEquipmentTypes();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.EquipmentType), TABLES.Equipment.EquipmentType);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEquipmentTypes_Fail()
		{
		}

		[Test]
		public void GetEquipmentManufacturerNames_Pass()
		{
			DataTable dtTest = DAL.Equipment.GetEquipmentManufacturerNames();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ManufacturerName), TABLES.Equipment.ManufacturerName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEquipmentManufacturerNames_Fail()
		{
		}

		[Test]
		public void GetManufacturerAddresses_Pass()
		{
			DataTable dtTest = DAL.Equipment.GetManufacturerAddresses(_dtEquipment.Rows[0][TABLES.Equipment.ManufacturerName].ToString());

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine1), TABLES.Address.AddressLine1);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine2), TABLES.Address.AddressLine2);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine3), TABLES.Address.AddressLine3);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressCity), TABLES.Address.AddressCity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.StateCode), TABLES.Address.StateCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressZipCode), TABLES.Address.AddressZipCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.ManufacturerPhoneNumber), TABLES.Equipment.ManufacturerPhoneNumber);

		}

		[Test]
		public void GetManufacturerAddresses_Fail()
		{
			DataTable dtTest = DAL.Equipment.GetManufacturerAddresses(string.Empty.PadRight(50,'X'));

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetEquipmentReport_Pass()
		{
			System.Guid addressGuid = System.Guid.NewGuid();
			System.Guid equipmentGuid = System.Guid.NewGuid();

			DataTable dtAddress = SprocHelper.GetInsertAddressSprocTable(addressGuid);
			DataTable dtEquipment = SprocHelper.GetInsertEquipmentSprocTable(equipmentGuid, addressGuid);
			System.Guid [] equipGuids = new Guid[1];
			equipGuids[0] = System.Guid.NewGuid();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.LoginEquipment);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.LoginEquipment, equipGuids, Common.WorkloadTransactionType.Miscellanious, false);
			DAL.Equipment.Insert(dtEquipment, dtAddress, dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			DataTable dtEquipmentMaintenance=DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable();
					
			DataRow drEquipmentMaintenance = dtEquipmentMaintenance.NewRow();
			drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.EquipmentMaintenanceGuid]=System.Guid.NewGuid();
			drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.EquipmentGuid] = equipmentGuid;
			drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.MaintenanceDate]=DateTime.Now.AddDays(-5);
			drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.MaintenanceResults]="UnitTest";
			drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.MaintenanceType]="UnitTest";
			drEquipmentMaintenance[Common.VbecsTables.EquipmentMaintenance.PendingIssues]="UnitTest";
			drEquipmentMaintenance[Common.VbecsTables.Equipment.DivisionCode]=UnitTestConfig.TestDivisionCode;
			dtEquipmentMaintenance.Rows.Add(drEquipmentMaintenance);

			DAL.EquipmentMaintenance.Save(dtEquipmentMaintenance, DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable(), Common.UpdateFunction.UnitTests);

			dtEquipment = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM Equipment WHERE EquipmentGuid = '" + equipmentGuid.ToString() + "'", true);
			dtAddress = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM Address WHERE AddressGuid = '" + addressGuid.ToString() + "'", true);

			DataTable dtAddressUpdate = SprocHelper.GetUpdateAddressSprocTable(addressGuid, (byte[])dtAddress.Rows[0][Common.VbecsTables.Address.RowVersion]);
			DataTable dtEquipmentUpdate = SprocHelper.GetUpdateEquipmentSprocTable(equipmentGuid, (byte[])dtEquipment.Rows[0][Common.VbecsTables.Equipment.RowVersion]);
			dtEquipmentUpdate.Rows[0][Common.VbecsTables.Equipment.AddressGuid] = addressGuid;
			equipGuids = new Guid[1];
			equipGuids[0] = System.Guid.NewGuid();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UpdateEquipmentRecord);
			dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UpdateEquipmentRecord, equipGuids, Common.WorkloadTransactionType.Miscellanious, false);
			DAL.Equipment.Update(dtEquipmentUpdate, dtAddressUpdate, new DataTable(), new DataTable(), dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			//
			DataSet dsTest = BOL.Equipment.GetEquipmentReport(equipmentGuid);
			//
			Assert.AreEqual(4, dsTest.Tables.Count, "Tables.Count");

			//TABLE 1 -----------------------------------------------------------------------------------------------------
			Assert.AreEqual(true, dsTest.Tables[0].Rows.Count > 0, "[0]-Rows.Count");
			Assert.AreEqual(25, dsTest.Tables[0].Columns.Count, "[0]-Columns.Count");	//Somehow 3 columns are being appended -- ADO.NET???

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.EquipmentGuid), "[0]-" + TABLES.Equipment.EquipmentGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.EquipmentName), "[0]-" + TABLES.Equipment.EquipmentName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.EquipmentType), "[0]-" + TABLES.Equipment.EquipmentType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.ManufacturerName), "[0]-" + TABLES.Equipment.ManufacturerName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Address.AddressGuid), "[0]-" + TABLES.Address.AddressGuid);

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Address.AddressLine1), "[0]-" + TABLES.Address.AddressLine1);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Address.AddressLine2), "[0]-" + TABLES.Address.AddressLine2);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Address.AddressCity), "[0]-" + TABLES.Address.AddressCity);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Address.StateCode), "[0]-" + TABLES.Address.StateCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Address.AddressZipCode), "[0]-" + TABLES.Address.AddressZipCode);

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.ManufacturerPhoneNumber), "[0]-" + TABLES.Equipment.ManufacturerPhoneNumber);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.ReceiptDate), "[0]-" + TABLES.Equipment.ReceiptDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.ReceiptTechId), "[0]-" + TABLES.Equipment.ReceiptTechId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.SerialNumber), "[0]-" + TABLES.Equipment.SerialNumber);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.LocalIdentifier), "[0]-" + TABLES.Equipment.LocalIdentifier);

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.MaintenanceContractNumber), "[0]-" + TABLES.Equipment.MaintenanceContractNumber);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.MaintenanceContractDate), "[0]-" + TABLES.Equipment.MaintenanceContractDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.OutOfServiceIndicator), "[0]-" + TABLES.Equipment.OutOfServiceIndicator);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.Comments), "[0]-" + TABLES.Equipment.Comments);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.NextMaintenanceText), "[0]-" + TABLES.Equipment.NextMaintenanceText);

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.LastUpdateDate), "[0]-" + TABLES.Equipment.LastUpdateDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Equipment.LastUpdateUser), "[0]-" + TABLES.Equipment.LastUpdateUser);

			//THESE COLUMNS ARE NOT IN THE SPROC, BUT APPEAR IN THE DS -- ONLY LOGICAL POSSIBILITES -- ADDED BY ADO OR SPACE HACKERS FROM URANUS
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains("MaintenanceRecordCount"), "[Uranus]-MaintenanceRecordCount");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains("EquipmentMirrorRecordCount"), "[Uranus]-EquipmentMirrorRecordCount");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains("AddressMirrorRecordCount"), "[Uranus]-AddressMirrorRecordCount");


			//TABLE 2 -----------------------------------------------------------------------------------------------------
			Assert.AreEqual(true, dsTest.Tables[1].Rows.Count > 0, "[1]-Rows.Count");
			Assert.AreEqual(9, dsTest.Tables[1].Columns.Count, "[1]-Columns.Count");

			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.EquipmentMaintenance.EquipmentGuid), "[1]-" + TABLES.EquipmentMaintenance.EquipmentGuid);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid), "[1]-" + TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceType), "[1]-" + TABLES.EquipmentMaintenance.MaintenanceType);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceDate), "[1]-" + TABLES.EquipmentMaintenance.MaintenanceDate);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceResults), "[1]-" + TABLES.EquipmentMaintenance.MaintenanceResults);

			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.EquipmentMaintenance.PendingIssues), "[1]-" + TABLES.EquipmentMaintenance.PendingIssues);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.EquipmentMaintenance.LastUpdateDate), "[1]-" + TABLES.EquipmentMaintenance.LastUpdateDate);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.EquipmentMaintenance.LastUpdateUser), "[1]-" + TABLES.EquipmentMaintenance.LastUpdateUser);
			Assert.AreEqual(true , dsTest.Tables[1].Columns.Contains(ARTIFICIAL.CurrentMaintenanceDate), "[1]-" + ARTIFICIAL.CurrentMaintenanceDate);

			//TABLE 3 -----------------------------------------------------------------------------------------------------
			Assert.AreEqual(true, dsTest.Tables[2].Rows.Count > 0, "[2]-Rows.Count");
			Assert.AreEqual(16, dsTest.Tables[2].Columns.Count, "[2]-Columns.Count");

			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.EquipmentName), "[2]-" + TABLES.Equipment.EquipmentName);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.EquipmentType), "[2]-" + TABLES.Equipment.EquipmentType);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.ManufacturerName), "[2]-" + TABLES.Equipment.ManufacturerName);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.ManufacturerPhoneNumber), "[2]-" + TABLES.Equipment.ManufacturerPhoneNumber);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.ReceiptDate), "[2]-" + TABLES.Equipment.ReceiptDate);
			
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.ReceiptTechId), "[2]-" + TABLES.Equipment.ReceiptTechId);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.SerialNumber), "[2]-" + TABLES.Equipment.SerialNumber);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.LocalIdentifier), "[2]-" + TABLES.Equipment.LocalIdentifier);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.MaintenanceContractNumber), "[2]-" + TABLES.Equipment.MaintenanceContractNumber);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.MaintenanceContractDate), "[2]-" + TABLES.Equipment.MaintenanceContractDate);
			
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.OutOfServiceIndicator), "[2]-" + TABLES.Equipment.OutOfServiceIndicator);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.Comments), "[2]-" + TABLES.Equipment.Comments);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.NextMaintenanceText), "[2]-" + TABLES.Equipment.NextMaintenanceText);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.LastUpdateDate), "[2]-" + TABLES.Equipment.LastUpdateDate);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.Equipment.LastUpdateUser), "[2]-" + TABLES.Equipment.LastUpdateUser);
			
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(ARTIFICIAL.MirrorDate), "[2]-" + ARTIFICIAL.MirrorDate);

			//TABLE 4 -----------------------------------------------------------------------------------------------------
			Assert.AreEqual(true, dsTest.Tables[3].Rows.Count > 0, "[3]-Rows.Count");
			Assert.AreEqual(9, dsTest.Tables[3].Columns.Count, "[3]-Columns.Count");

			Assert.AreEqual(true, dsTest.Tables[3].Columns.Contains(TABLES.Address.AddressGuid), "[3]-" + TABLES.Address.AddressGuid);
			Assert.AreEqual(true, dsTest.Tables[3].Columns.Contains(TABLES.Address.AddressLine1), "[3]-" + TABLES.Address.AddressLine1);
			Assert.AreEqual(true, dsTest.Tables[3].Columns.Contains(TABLES.Address.AddressLine2), "[3]-" + TABLES.Address.AddressLine2);
			Assert.AreEqual(true, dsTest.Tables[3].Columns.Contains(TABLES.Address.AddressCity), "[3]-" + TABLES.Address.AddressCity);
			Assert.AreEqual(true, dsTest.Tables[3].Columns.Contains(TABLES.Address.StateCode), "[3]-" + TABLES.Address.StateCode);

			Assert.AreEqual(true, dsTest.Tables[3].Columns.Contains(TABLES.Address.AddressZipCode), "[3]-" + TABLES.Address.AddressZipCode);
			Assert.AreEqual(true, dsTest.Tables[3].Columns.Contains(TABLES.Address.LastUpdateDate), "[3]-" + TABLES.Address.LastUpdateDate);
			Assert.AreEqual(true, dsTest.Tables[3].Columns.Contains(TABLES.Address.LastUpdateUser), "[3]-" + TABLES.Address.LastUpdateUser);
			Assert.AreEqual(true, dsTest.Tables[3].Columns.Contains(ARTIFICIAL.MirrorDate), "[3]-" + ARTIFICIAL.MirrorDate);
		}

		[Test]
		public void GetEquipmentReport_Fail()
		{
			DataSet dsTest = BOL.Equipment.GetEquipmentReport(Guid.NewGuid());

			Assert.AreEqual(4, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "[0]-Rows.Count");
			Assert.AreEqual(0, dsTest.Tables[1].Rows.Count, "[1]-Rows.Count");
			Assert.AreEqual(0, dsTest.Tables[2].Rows.Count, "[2]-Rows.Count");
			Assert.AreEqual(0, dsTest.Tables[3].Rows.Count, "[3]-Rows.Count");
		}



	}
}

#endif



